
$TITLE  Glass Optim Case 3b: Linear or nonlin property models w/o uncert  (modified constraints)

$OFFUPPER OFFSYMXREF OFFSYMLIST OFFLISTING

$ONTEXT
This fiel was modified by Amit Goyal and Urmila Diwekar
***********************************************************************
***********************************************************************
* NOTICE: The OWL models are undergoing continuing development.       *
* They have not been verified or validated, and software control      *
* procedures have not yet been implemented.  Any use of the results   *
* of this software are the sole responsibility of the user.  The      *
* developer of this software makes no claims as to the accuracy,      *
* completeness, or usefulness of information as a result of the       *
* software's use.                                                     *
***********************************************************************
***********************************************************************




MODEL DESCRIPTION

This is the base case (OWL-Base) formulation of the waste loading
maximization problem.  It uses linear or nonlinear glass property
models and does not take into account uncertainties in the models.  It
requires the following additional files.  Different versions of each
may exist, allowing flexibility in running different types of problems
without modifying the main model code.  The required files (and
different versions) are listed below:


  sainput1.inc   - contains all changeable parameters except for waste
                 composition
  sawastcomp.prn - a lotus 123 print file that contains waste composition
                 data (in a specific format)
  saglmdl1.inc   - contains the coefficients for the glass property models
  sacalcspec.inc - contains the instructions for performing the
                 calculations, calculating additional information, and
                 printing output
  sabinvarinp.inc - Initializes the composition of blends

$OFFTEXT

* Turn off equation listing in output
OPTION LIMROW = 0
OPTION LIMCOL = 0
OPTION SOLPRINT = OFF
OPTION SYSOUT   = OFF

* Define primary index variables ========================================

SETS
  Mstr  master set of all set elements
        /SiO2, B2O3, Na2O, Li2O, CaO, MgO, Fe2O3, Al2O3,
                 ZrO2, Other, Cr2O3, F, P2O5, SO3, NobMet, OxideMass  /
  Comp(Mstr) input file waste components and parameters
             /SiO2, B2O3, Na2O, Li2O, CaO, MgO, Fe2O3, Al2O3,
                 ZrO2, Other, Cr2O3, F, P2O5, SO3, NobMet, OxideMass  /
  C(Mstr)  all waste components tracked
           /SiO2, B2O3, Na2O, Li2O, CaO, MgO, Fe2O3, Al2O3,
                 ZrO2, Other, Cr2O3, F, P2O5, SO3, NobMet/
  I(Mstr)  waste components for glass property models
           /SiO2, B2O3, Na2O, Li2O, CaO, MgO, Fe2O3, Al2O3, ZrO2, Other/
  K(Mstr)  waste components for solubility constraints
           /Cr2O3, F, P2O5, SO3, NobMet/
  Blends   declaring the three blends
           /1*3/
  position /1*7/;

$ONTEXT
The waste components in set K are treated differently than those in set
I. They are included in the glass property models as part of Other.
Their only use is for solubility constraints (expressed as upper limits
on the variables).
$OFFTEXT

* Make index J equivalent to index I (necessary for matrix computations)
ALIAS (I,J);


* Declare Parameters and Variables ======================================

Parameters

  MassOxide(Blends)  total mass (kg) of oxides in waste
  Viscosity(Blends)  PaS
  ElectCond(Blends)  'S/m'
  BorDissPCT(Blends) 'g/m2/day'
  BorDissMCC(Blends) 'g/m2/day'
  CanMass    mass (kg) of glass per canister;

POSITIVE VARIABLES
  NumCans(Blends)    number of canisters of glass required
  FW(Blends,Mstr)   Mass fraction of each component in the waste
  Frit
  FG(Blends,Mstr)  Mass fraction of each component in the glass
  FF(Blends,Mstr)  Mass fraction of each component in the frit
  TMWG(Blends)   Total mass (per canister) of waste in the glass (kg)
  TMFG(Blends)   Total mass (per canister) of frit in the glass (kg)
  Glass(Blends)     Total mass of glass formed;


* Read PRN file with waste set declarations =============================
* and waste compositions

$include "sawastcomp.prn"


 Binary variable

y(blends,waste,position)  decision variable;

 Parameter

 z(blends,waste,position)  decision parameter;

FREE VARIABLE

  TotalFrit
  Wastefrac(blends);


* Set values of scalars, parameters, variable bounds, initial values  ===

$include "sainput1.inc"
$include "sabinvarinp.inc"



* Define glass property model coefficients ==============================

$include "saglmdl1.inc"




* Define equations and constraints ======================================

EQUATIONS
  Totfrit
  FracW(Blends,C)
  Numcan(Blends)
  Glas(Blends)
  Fritt(Blends)
  WasteFract(Blends)   defines mass fraction of waste glass - maximized variable
  FracSumF(Blends)     sum of mass fractions in frit must = 1.0
  FracSumG(Blends)     sum of mass fractions in glass must = 1.0
  GlassComp(Blends,C)  calculate glass mass fractions for glass model components
  GlassMass(Blends)    glass = waste + frit
  Crystal1(Blends)     glass crystallinity constraint
  Crystal2(Blends)     glass crystallinity constraint
  Crystal3(Blends)     glass crystallinity constraint
  Crystal4(Blends)     glass crystallinity constraint
  Crystal5(Blends)     glass crystallinity constraint
  ViscLwr(Blends)      viscosity greater than lower limit
  ViscUpr(Blends)      viscosity less than upper limit
  ECondLwr(Blends)     e-conductivity greater than lower limit
  ECondUpr(Blends)     e-conductivity less than upper limit
  DissPCTbor(Blends)   dissolution rate for boron by PCT test less than max allowable
  DissMCCbor(Blends)   dissolution rate for boron by MCC test less than max allowableWasteFract(Blends)
  ;



FracW(Blends,C)    ..      FW(Blends,C)*Massoxide(Blends)   =E= SUM(Waste, SUM(position,z(Blends,Waste,Position)) * WasteComps(C, Waste)*
                                                 WasteComps('OxideMass', Waste));

Numcan(Blends)     ..      NumCans(Blends)*TMWG(Blends) =E= MassOxide(Blends);

Glas(Blends)       ..      Glass(Blends)   =E= NumCans(Blends)* MaxLogMass;

Fritt(Blends)      ..      Frit(Blends)    =E= NumCans(Blends)* TMFG(Blends);

Totfrit         ..         Totalfrit =E= SUM(Blends,Frit(Blends));

WasteFract(Blends) ..      WasteFrac(Blends)*MaxLogMass  =E= TMWG(Blends);

FracSumF(Blends) ..        1.0 =E= SUM(I,FF(Blends,I));

FracSumG(Blends) ..        1.0 =E= SUM(J,FG(Blends,J));

GlassComp(Blends,C) ..     FG(Blends,C)*MaxLogMass =E= (FF(Blends,C)*TMFG(Blends) + FW(Blends,C)*TMWG(Blends)) ;

GlassMass(Blends) ..       TMFG(Blends) + TMWG(Blends) =E= MaxLogMass;

Crystal1(Blends) .. FG(Blends,'SiO2') =G= FG(Blends,'Al2O3')*Cryst1Bnd;

Crystal2(Blends) .. FG(Blends,'MgO')+FG(Blends,'CaO') =L= Cryst2Bnd;

Crystal3(Blends) .. FG(Blends,'Fe2O3')+FG(Blends,'Al2O3')+FG(Blends,'ZrO2')+FG(Blends,'Other') =L= Cryst3Bnd;

Crystal4(Blends) .. FG(Blends,'Al2O3')+FG(Blends,'ZrO2') =L= Cryst4Bnd;

Crystal5(Blends) .. FG(Blends,'MgO')+FG(Blends,'CaO')+FG(Blends,'ZrO2') =L= Cryst5Bnd  ;

ViscLwr(Blends) ..  SUM(I,AV(I)*FG(Blends,I)) + SUM((I,J),BV(I,J)*FG(Blends,I)*FG(Blends,J))
                                                    =G= LOG(ViscMin) ;

ViscUpr(Blends) ..  SUM(I,AV(I)*FG(Blends,I)) + SUM((I,J),BV(I,J)*FG(Blends,I)*FG(Blends,J))
                                                    =L= LOG(ViscMax) ;

ECondLwr(Blends) .. SUM(I,AE(I)*FG(Blends,I)) + SUM((I,J),BE(I,J)*FG(Blends,I)*FG(Blends,J))
                                                    =G= LOG(ECondMin) ;

ECondUpr(Blends) ..  SUM(I,AE(I)*FG(Blends,I)) + SUM((I,J),BE(I,J)*FG(Blends,I)*FG(Blends,J))
                                                    =L= LOG(ECondMax) ;

DissPCTbor(Blends).. SUM(I,ADPB(I)*FG(Blends,I)) + SUM((I,J),BDPB(I,J)*FG(Blends,I)*FG(Blends,J))
                                                    =L= LOG(DissMaxPCT) ;

DissMCCbor(Blends).. SUM(I,ADMB(I)*FG(Blends,I)) + SUM((I,J),BDMB(I,J)*FG(Blends,I)*FG(Blends,J))
                                                    =L= LOG(DissMaxMCC) ;

* Declare model name  ===================================================
MODEL WASTEOPTIM /ALL/;
WASTEOPTIM.OPTFILE = 1;



* Specify calculation sequence and solution method ======================

$include "sacalcspec1exp.inc"